# 🚀 Quick Start Guide

## 5-Minute Setup

### 1. Prerequisites Check

```bash
# Check Docker
docker --version
docker-compose --version

# If not installed:
# Ubuntu/Debian: sudo apt install docker.io docker-compose
# Mac: brew install docker docker-compose
# Or download from: https://www.docker.com/
```

### 2. Get Your Anthropic API Key

1. Visit: https://console.anthropic.com/
2. Sign up / Log in
3. Go to "API Keys"
4. Create new key
5. Copy it (starts with `sk-ant-`)

### 3. Setup Project

```bash
cd crypto-ai-trader

# Create .env file
cp .env.example .env

# Edit .env and add your key
nano .env
# Change this line:
# ANTHROPIC_API_KEY=sk-ant-your-key-here
```

### 4. Launch Everything

```bash
# Start all services
docker-compose up -d

# This will:
# - Pull required Docker images
# - Build backend and frontend
# - Initialize database
# - Start all services
# Takes 3-5 minutes first time
```

### 5. Verify It's Running

```bash
# Check services status
docker-compose ps

# Should show 3 services running:
# - crypto_trader_db
# - crypto_trader_backend
# - crypto_trader_frontend

# Check backend logs
docker-compose logs backend

# Should see:
# "Application started successfully"
# "AI trading loop started"
```

### 6. Open Dashboard

Open browser to: **http://localhost:3000**

You should see:
- Portfolio showing $10,000 initial balance
- AI Status card
- Empty trades (AI will trade soon!)

### 7. Test Manual Analysis

Click "Trigger AI Analysis" button

Within 10-20 seconds:
- AI Signal card appears with reasoning
- If confidence high enough, trade executes
- Portfolio updates
- Trade appears in table

## 🎉 You're Running!

The AI will now:
- Analyze markets every 60 seconds
- Make trading decisions
- Execute paper trades
- Update dashboard real-time

## ⚙️ Configuration

Edit `.env` to customize:

```bash
# Trading frequency
AI_CHECK_INTERVAL_SECONDS=60  # Check every minute

# Confidence threshold
AI_MIN_CONFIDENCE=0.70  # Only trade if 70%+ confident

# Position sizing
MAX_POSITION_SIZE_PCT=0.30  # Max 30% portfolio per trade
RISK_PER_TRADE_PCT=0.02     # Max 2% loss per trade

# Symbols to trade
DEFAULT_SYMBOLS=BTC/USDT,ETH/USDT
```

After changing, restart:
```bash
docker-compose restart backend
```

## 🔍 Monitoring

### View Logs

```bash
# Backend logs (AI decisions, trades)
docker-compose logs -f backend

# Database logs
docker-compose logs -f db

# Frontend logs
docker-compose logs -f frontend
```

### Check Database

```bash
# Connect to database
docker-compose exec db psql -U trader -d crypto_trading

# Useful queries:
# SELECT * FROM trades ORDER BY timestamp DESC LIMIT 10;
# SELECT * FROM ai_signals ORDER BY timestamp DESC LIMIT 10;
# SELECT * FROM portfolio_snapshots ORDER BY timestamp DESC LIMIT 5;
```

### API Docs

Visit: **http://localhost:8000/docs**

Interactive API documentation with all endpoints

## 🛑 Stop Everything

```bash
# Stop services (keeps data)
docker-compose stop

# Stop and remove containers (keeps data)
docker-compose down

# DANGER: Remove everything including data
docker-compose down -v
```

## 🔄 Restart Fresh

```bash
# Stop everything
docker-compose down -v

# Start again (fresh database)
docker-compose up -d
```

## 🐛 Troubleshooting

### Backend won't start

```bash
# Check logs
docker-compose logs backend

# Common issue: Invalid API key
# Solution: Check .env has correct ANTHROPIC_API_KEY
```

### Database connection error

```bash
# Restart database
docker-compose restart db

# Wait 10 seconds
sleep 10

# Restart backend
docker-compose restart backend
```

### Frontend shows errors

```bash
# Rebuild frontend
docker-compose build --no-cache frontend
docker-compose up -d frontend
```

### Port already in use

If port 3000, 8000, or 5432 already in use:

Edit `docker-compose.yml`:
```yaml
# Change:
ports:
  - "3000:80"  # Frontend
  
# To:
ports:
  - "3001:80"  # Use different port
```

## 📊 Expected Behavior

After 1 hour running:
- 60 AI analysis cycles completed
- 0-5 trades executed (depends on market)
- Portfolio within -2% to +5% range
- AI confidence varies 0.40-0.90

After 1 day:
- 1440 analysis cycles
- 5-20 trades typically
- More stable patterns emerge

## 🎯 Next Steps

Once comfortable with MVP:
1. Read full README.md
2. Customize AI prompts in `backend/app/services/ai_strategy.py`
3. Add more indicators in `backend/app/utils/indicators.py`
4. Extend frontend with charts
5. Add backtesting

## 💡 Tips

- Paper trading only - no real money at risk!
- Watch AI reasoning to learn its logic
- Lower confidence threshold = more trades
- Higher confidence = safer but fewer trades
- Start conservative, tune after observing

## 🆘 Need Help?

1. Check logs: `docker-compose logs backend`
2. Check GitHub Issues
3. Review code comments
4. All code is well-documented

---

**Ready to evolve to production?** Read PRODUCTION.md (coming soon!)
